@extends('layouts.app') @section('content')
<div class="content-wrapper">
	<div class="content pt-3">
		<div class="container-fluid">
			<div class="row">
				<div class="col-12">
					<div class="card border-0 shadow-custom">
						<div class="card-header border-grey">
							<h3 class="card-title">
								{{ __('notification.title') }}
							</h3>
						</div>
						<div class="card-body">
							<div class="row">
								<div class="col-md-12 d-flex justify-content-end">
									<form method="post" action="{{ route('member.unpaid') }}">
										{{ csrf_field() }}
										<div class="input-group mb-3">
											<input type="text" name="search" class="form-control" placeholder="Search"
												required />
											<div class="input-group-append">
												<button class="btn btn-primary" type="submit">
													<i class="fas fa-search"></i>
												</button>
											</div>
										</div>
									</form>
								</div>
								<div class="col-12">
									<div class="table-responsive">
										<table class="table custom-table-bordered table-hover">
											<thead>
												<tr>
													<th class="nowrap">{{ __('notification.th_reg_no') }}</th>
													<th>{{ __('notification.th_name') }}</th>
													<th>{{ __('notification.th_phone') }}</th>
													<th class="nowrap">{{ __('notification.th_membership_type') }}</th>
													<th class="nowrap">{{ __('notification.th_valid_from') }}</th>
													<th class="nowrap">{{ __('notification.th_valid_to') }}</th>
													<th class="nowrap">{{ __('notification.th_amount') }}</th>
													<th class="nowrap">{{ __('notification.th_paid') }}</th>
													<th class="nowrap">{{ __('notification.th_due') }}</th>
													<th class="nowrap">{{ __('notification.th_payment_status') }}</th>
													<th class="fixed-width-td">{{ __('notification.th_action') }}</th>
												</tr>
											</thead>
											<tbody>
												@foreach($memberships as $membership)
												<tr>
													<td class="align-middle">{{ $membership->reg_no }}</td>
													<td class="align-middle nowrap">
														{{ $membership->name }}
													</td>
													<td class="align-middle">
														{{ $membership->phone }}
													</td>
													<td class="align-middle nowrap">
														{{ $membership->membership_name }}
													</td>
													<td class="align-middle nowrap">
														{{ format_date($membership->valid_from) }}
													</td>
													<td class="align-middle nowrap">
														{{ format_date($membership->valid_to) }}
													</td>
													<td class="align-middle nowrap">
														{{ currency_symbol() }}
														{{ round_off($membership->actual_amount) }}
													</td>
													<td class="align-middle nowrap">
														{{ currency_symbol() }}
														{{ round_off($membership->total_paid) }}
													</td>
													<td class="align-middle nowrap">
														{{ currency_symbol() }}
														{{ round_off($membership->due_amount) }}
													</td>
													<td class="align-middle nowrap">
														{!! payment_status($membership->actual_amount,
														$membership->total_paid) !!}
													</td>
													<td>
														<div class="d-flex">
															<a href="{{ route('transaction.create', $membership->id) }}"
																type="button" class="btn btn-success mr-2">
																<i class="fa fa-plus"></i>
															</a>
															<a href="{{ route('invoice.show', $membership->id) }}"
																type="button" class="btn btn-warning">
																<i class="fa fa-print"></i>
															</a>
														</div>
													</td>
												</tr>
												@endforeach
												@if(count($memberships) == 0)
												<tr>
													<td colspan="11">
														<p class="text-center mb-0">{{
															__('notification.no_record_found') }}</p>
													</td>
												</tr>
												@endif
											</tbody>
										</table>
									</div>
								</div>
								<div class="col-12">
									<div class="d-flex justify-content-end">
										@if($paginate)
										{{ $memberships->links() }}
										@endif
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
@endsection